/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.pkgmgr.PackageFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Any)
public class BlueJPackageFile
implements PackageFile {
    private static final String pkgfileName = "package.bluej";
    private static final String oldPkgfileName = "bluej.pkg";
    private File dir;
    private File pkgFile;
    private File oldPkgFile;

    @OnThread(value=Tag.Any)
    BlueJPackageFile(File dir) {
        this.dir = dir;
        this.pkgFile = new File(dir, pkgfileName);
        this.oldPkgFile = new File(dir, oldPkgfileName);
    }

    public String toString() {
        return "BlueJ package file in: " + this.dir.toString();
    }

    public static boolean exists(File dir) {
        if (dir == null) {
            return false;
        }
        if (dir.getPath().endsWith(":\\")) {
            return false;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        File packageFile = new File(dir, pkgfileName);
        if (packageFile.exists()) {
            return true;
        }
        File oldPackageFile = new File(dir, oldPkgfileName);
        return oldPackageFile.exists();
    }

    @Override
    public void load(Properties p) throws IOException {
        try (FileInputStream input = null;){
            if (this.pkgFile.canRead()) {
                input = new FileInputStream(this.pkgFile);
            } else if (this.oldPkgFile.canRead()) {
                input = new FileInputStream(this.oldPkgFile);
            } else {
                throw new IOException("Can't read from package file(s) in: " + String.valueOf(this));
            }
            p.load(input);
        }
    }

    @Override
    public void save(Properties props) throws IOException {
        if (this.oldPkgFile.exists()) {
            if (!this.oldPkgFile.canWrite()) {
                throw new IOException("BlueJ package file not writable: " + String.valueOf(this.oldPkgFile));
            }
            this.saveToFile(props, this.oldPkgFile);
        }
        this.pkgFile.createNewFile();
        if (!this.pkgFile.canWrite()) {
            throw new IOException("BlueJ package file not writable: " + String.valueOf(this.pkgFile));
        }
        this.saveToFile(props, this.pkgFile);
    }

    private void saveToFile(Properties props, File file) throws IOException {
        try (FileOutputStream output = null;){
            output = new FileOutputStream(file);
            String header = "BlueJ package file";
            props.store(output, header);
        }
    }

    public static boolean isPackageFileName(String name) {
        return name.equals(pkgfileName) || name.equals(oldPkgfileName);
    }

    public static boolean isOldPackageFileName(String name) {
        return name.equals(oldPkgfileName);
    }

    @Override
    public boolean create() throws IOException {
        File pkgFile = new File(this.dir, pkgfileName);
        File oldPkgFile = new File(this.dir, oldPkgfileName);
        boolean created = false;
        if (pkgFile.exists() && !oldPkgFile.exists()) {
            return false;
        }
        if (!pkgFile.exists()) {
            pkgFile.createNewFile();
            created = true;
        }
        return created;
    }
}

