/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.target;

import bluej.extmgr.ClassExtensionMenu;
import bluej.extmgr.ExtensionMenu;
import bluej.extmgr.ExtensionsManager;
import bluej.extmgr.ExtensionsMenuManager;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PackageEditor;
import bluej.pkgmgr.target.ClassTarget;
import bluej.utility.javafx.AbstractOperation;
import bluej.utility.javafx.JavaFXUtil;
import java.util.Map;
import java.util.Properties;
import javafx.css.Styleable;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.AccessibleRole;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.effect.ColorAdjust;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Line;
import threadchecker.OnThread;
import threadchecker.Tag;

public abstract class Target
implements Comparable<Target>,
AbstractOperation.ContextualItem<Target> {
    static final int DEF_WIDTH = 120;
    static final int DEF_HEIGHT = 70;
    static final int ARR_HORIZ_DIST = 5;
    static final int ARR_VERT_DIST = 10;
    static final int HANDLE_SIZE = 20;
    static final int TEXT_HEIGHT = 16;
    static final int TEXT_BORDER = 4;
    static final int SHAD_SIZE = 4;
    private static final double SHADOW_RADIUS = 3.0;
    protected static final double RESIZE_CORNER_SIZE = 16.0;
    protected static final double RESIZE_CORNER_GAP = 4.0;
    private @OnThread(value=Tag.FXPlatform) int preMoveX;
    private @OnThread(value=Tag.FXPlatform) int preMoveY;
    private @OnThread(value=Tag.FXPlatform) int preResizeWidth;
    private @OnThread(value=Tag.FXPlatform) int preResizeHeight;
    private @OnThread(value=Tag.FXPlatform) double pressDeltaX;
    private @OnThread(value=Tag.FXPlatform) double pressDeltaY;
    private @OnThread(value=Tag.FXPlatform) ContextMenu showingContextMenu;
    private @OnThread(value=Tag.Any, requireSynchronized=true) String identifierName;
    private String displayName;
    private @OnThread(value=Tag.Any, requireSynchronized=true) Package pkg;
    protected @OnThread(value=Tag.Any) boolean selected;
    protected boolean queued;
    protected @OnThread(value=Tag.FXPlatform) BorderPane pane = JavaFXUtil.initFX(BorderPane::new);
    private @OnThread(value=Tag.FX) boolean resizable = true;
    private @OnThread(value=Tag.FX) boolean resizing = false;
    private @OnThread(value=Tag.FX) boolean moving = false;
    private @OnThread(value=Tag.FXPlatform) Line line1;
    private Line line2;

    @OnThread(value=Tag.FXPlatform)
    public Target(Package pkg, String identifierName, String accessibleTargetType) {
        this.pkg = pkg;
        this.identifierName = identifierName;
        this.displayName = identifierName;
        this.pane.setPrefWidth((double)Target.calculateWidth((Labeled)new Label(), identifierName, 120));
        this.pane.setPrefHeight(70.0);
        this.pane.setCursor(Cursor.HAND);
        JavaFXUtil.addStyleClass((Styleable)this.pane, "target");
        this.pane.setEffect((Effect)new DropShadow(3.0, 1.5, 1.5, Color.GRAY));
        this.pane.setFocusTraversable(true);
        this.updateAccessibleName(accessibleTargetType, null);
        this.pane.setAccessibleRole(AccessibleRole.BUTTON);
        JavaFXUtil.addFocusListener((Node)this.pane, hasFocus -> {
            PackageEditor pkgEditor = pkg.getEditor();
            if (pkgEditor == null) {
                return;
            }
            if (hasFocus.booleanValue() && !this.isSelected()) {
                pkgEditor.selectOnly(this);
            }
            if (!hasFocus.booleanValue()) {
                pkgEditor.checkForLossOfFocus();
            }
        });
        this.pane.setOnMouseClicked(e -> {
            if (e.getClickCount() > 1 && e.getButton() == MouseButton.PRIMARY && !e.isPopupTrigger()) {
                this.doubleClick(e.isShiftDown());
            } else if (e.getClickCount() == 1 && e.getButton() == MouseButton.PRIMARY && !e.isPopupTrigger()) {
                if (!pkg.getEditor().clickForExtends(this, e.getSceneX(), e.getSceneY())) {
                    if (e.isShiftDown() || e.isShortcutDown()) {
                        pkg.getEditor().toggleSelection(this);
                    } else {
                        pkg.getEditor().selectOnly(this);
                    }
                }
                this.updateCursor((MouseEvent)e, false);
                if (this.isSelected()) {
                    this.pane.requestFocus();
                }
            }
            e.consume();
        });
        this.pane.setOnMouseMoved(e -> {
            this.updateCursor((MouseEvent)e, false);
            pkg.getEditor().setMouseIn(this);
        });
        this.pane.setOnMouseExited(e -> pkg.getEditor().setMouseLeft(this));
        this.pane.setOnMousePressed(e -> {
            this.pressDeltaX = e.getX();
            this.pressDeltaY = e.getY();
            if (e.getButton() == MouseButton.PRIMARY && !e.isPopupTrigger()) {
                this.showingMenu(null);
                if (this.isSelected() && this.cursorAtResizeCorner((MouseEvent)e) && this.isResizable()) {
                    pkg.getEditor().startedResize();
                } else {
                    pkg.getEditor().startedMove();
                    this.moving = true;
                }
            }
            e.consume();
        });
        this.pane.setOnMouseDragged(e -> {
            if (e.getButton() == MouseButton.PRIMARY && !pkg.getEditor().isCreatingExtends() && !e.isControlDown()) {
                if (this.isSelected() && this.isResizable() && this.resizing && !this.moving) {
                    int newWidth = pkg.getEditor().snapToGrid((int)(e.getX() + ((double)this.preResizeWidth - this.pressDeltaX)));
                    int newHeight = pkg.getEditor().snapToGrid((int)(e.getY() + ((double)this.preResizeHeight - this.pressDeltaY)));
                    pkg.getEditor().resizeBy(newWidth - this.preResizeWidth, newHeight - this.preResizeHeight);
                } else if (this.isSelected() && this.cursorAtResizeCorner((MouseEvent)e) && this.isResizable() && !this.moving) {
                    this.resizing = true;
                } else if (this.isMoveable() && !e.isStillSincePress()) {
                    if (!this.isSelected()) {
                        pkg.getEditor().selectOnly(this);
                        pkg.getEditor().startedMove();
                    }
                    Point2D p = pkg.getEditor().sceneToLocal(e.getSceneX(), e.getSceneY());
                    int newX = pkg.getEditor().snapToGrid((int)(p.getX() - this.pressDeltaX));
                    int newY = pkg.getEditor().snapToGrid((int)(p.getY() - this.pressDeltaY));
                    pkg.getEditor().moveBy(newX - this.preMoveX, newY - this.preMoveY);
                    this.updateCursor((MouseEvent)e, true);
                    this.moving = true;
                }
                this.showingMenu(null);
            }
            e.consume();
        });
        this.pane.setOnMouseReleased(e -> {
            if (e.getButton() == MouseButton.PRIMARY && !e.isPopupTrigger()) {
                pkg.getEditor().endResize();
            }
            this.resizing = false;
            this.moving = false;
        });
        this.pane.setOnKeyTyped(e -> {
            if (e.getCharacter().length() > 0 && "+-".contains(e.getCharacter()) && this.isResizable()) {
                pkg.getEditor().startedResize();
                int delta = e.getCharacter().equals("+") ? 10 : -10;
                pkg.getEditor().resizeBy(delta, delta);
                pkg.getEditor().endResize();
                e.consume();
            } else if (Character.isJavaIdentifierStart(e.getCharacter().codePointAt(0)) || Character.isJavaIdentifierPart(e.getCharacter().codePointAt(0))) {
                pkg.getEditor().typedAtTarget(e.getCharacter());
            }
        });
        this.pane.setOnKeyPressed(e -> {
            if (this.showingContextMenu != null) {
                return;
            }
            if (Target.isArrowKey(e)) {
                if (e.isControlDown()) {
                    if (this.isResizable()) {
                        pkg.getEditor().startedResize();
                        int d = 10;
                        pkg.getEditor().resizeBy(e.getCode() == KeyCode.LEFT ? -d : (e.getCode() == KeyCode.RIGHT ? d : 0), e.getCode() == KeyCode.UP ? -d : (e.getCode() == KeyCode.DOWN ? d : 0));
                        pkg.getEditor().endResize();
                    }
                } else if (e.isShiftDown()) {
                    if (this.isMoveable()) {
                        pkg.getEditor().startedMove();
                        int d = 10;
                        pkg.getEditor().moveBy(e.getCode() == KeyCode.LEFT ? -d : (e.getCode() == KeyCode.RIGHT ? d : 0), e.getCode() == KeyCode.UP ? -d : (e.getCode() == KeyCode.DOWN ? d : 0));
                    }
                } else {
                    pkg.getEditor().navigate((KeyEvent)e);
                }
                e.consume();
            } else if (e.getCode() == KeyCode.ESCAPE) {
                if (pkg.getEditor() != null) {
                    pkg.getEditor().selectOnly(this);
                }
                e.consume();
            } else if (e.getCode() == KeyCode.A && e.isShortcutDown() && !e.isAltDown()) {
                pkg.getEditor().selectAll();
                e.consume();
            }
        });
        JavaFXUtil.listenForContextMenu((Node)this.pane, (x, y) -> {
            if (!pkg.getEditor().getSelection().contains(this)) {
                pkg.getEditor().selectOnly(this);
            }
            AbstractOperation.MenuItems menuItems = AbstractOperation.getMenuItems(pkg.getEditor().getSelection(), true);
            ContextMenu contextMenu = AbstractOperation.MenuItems.makeContextMenu(Map.of("", menuItems));
            if (pkg.getEditor().getSelection().size() == 1 && pkg.getEditor().getSelection().get(0) instanceof ClassTarget) {
                ClassTarget classTarget = (ClassTarget)pkg.getEditor().getSelection().get(0);
                ExtensionsMenuManager menuManager = new ExtensionsMenuManager(contextMenu, ExtensionsManager.getInstance(), (ExtensionMenu)new ClassExtensionMenu(classTarget));
                menuManager.addExtensionMenu(this.getPackage().getProject());
            }
            this.showingMenu(contextMenu);
            contextMenu.show((Node)this.pane, (double)x.intValue(), (double)y.intValue());
            return true;
        }, KeyCode.SPACE, KeyCode.ENTER);
        if (pkg == null) {
            throw new NullPointerException();
        }
    }

    protected void updateAccessibleName(String accessibleTargetType, String suffix) {
        this.pane.setAccessibleText(this.getIdentifierName() + (String)(accessibleTargetType != null && !accessibleTargetType.isEmpty() ? " " + accessibleTargetType : "") + (suffix == null ? "" : suffix));
    }

    @OnThread(value=Tag.FXPlatform)
    private void updateCursor(MouseEvent e, boolean moving) {
        if (moving) {
            this.pane.setCursor(Cursor.MOVE);
        } else if (this.isSelected() && this.isResizable() && this.cursorAtResizeCorner(e)) {
            this.pane.setCursor(Cursor.SE_RESIZE);
        } else {
            this.pane.setCursor(Cursor.HAND);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    protected boolean cursorAtResizeCorner(MouseEvent e) {
        return e.getX() + e.getY() >= (double)(this.getWidth() + this.getHeight()) - 16.0 || this.resizing;
    }

    @OnThread(value=Tag.FX)
    protected static int calculateWidth(Labeled node, String name, int minWidth) {
        int width = 0;
        if (name != null) {
            width = (int)JavaFXUtil.measureString(node, name);
        }
        if (width + 20 <= minWidth) {
            return minWidth;
        }
        return (width + 20 + 9) / 10 * 10;
    }

    public synchronized void setRemoved() {
        this.pkg = null;
    }

    public void load(Properties props, String prefix) throws NumberFormatException {
        int xpos = 0;
        int ypos = 0;
        int width = 20;
        int height = 10;
        try {
            xpos = Math.max(Integer.parseInt(props.getProperty(prefix + ".x")), 0);
            ypos = Math.max(Integer.parseInt(props.getProperty(prefix + ".y")), 0);
            width = Math.max(Integer.parseInt(props.getProperty(prefix + ".width")), 1);
            height = Math.max(Integer.parseInt(props.getProperty(prefix + ".height")), 1);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.setPos(xpos, ypos);
        this.setSize(width, height);
    }

    @OnThread(value=Tag.FXPlatform)
    public void save(Properties props, String prefix) {
        props.put(prefix + ".x", String.valueOf(this.getX()));
        props.put(prefix + ".y", String.valueOf(this.getY()));
        props.put(prefix + ".width", String.valueOf(this.getWidth()));
        props.put(prefix + ".height", String.valueOf(this.getHeight()));
        props.put(prefix + ".name", this.getIdentifierName());
    }

    @OnThread(value=Tag.Any)
    public synchronized Package getPackage() {
        return this.pkg;
    }

    public void setDisplayName(String name) {
        this.displayName = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @OnThread(value=Tag.Any)
    public synchronized String getIdentifierName() {
        return this.identifierName;
    }

    public synchronized void setIdentifierName(String newName) {
        this.identifierName = newName;
    }

    @OnThread(value=Tag.FXPlatform)
    public void setSelected(boolean selected) {
        this.selected = selected;
        JavaFXUtil.setPseudoclass("bj-selected", selected, new Node[]{this.pane});
        this.redraw();
    }

    @OnThread(value=Tag.FXPlatform)
    protected void redraw() {
        this.removeResizingLines();
        this.drawResizingLines();
    }

    @OnThread(value=Tag.FXPlatform)
    protected void drawResizingLines() {
        if (this.selected && this.isResizable() && this.line1 == null && this.line2 == null) {
            this.line1 = new Line(this.pane.getWidth() - 16.0, this.pane.getHeight(), this.pane.getWidth(), this.pane.getHeight() - 16.0);
            this.line2 = new Line(this.pane.getWidth() - 16.0 + 4.0, this.pane.getHeight(), this.pane.getWidth(), this.pane.getHeight() - 16.0 + 4.0);
            this.pane.getChildren().add((Object)this.line1);
            this.pane.getChildren().add((Object)this.line2);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    protected void removeResizingLines() {
        if (this.isResizable() && this.line1 != null && this.line2 != null) {
            int size = this.pane.getChildren().size();
            this.pane.getChildren().remove(size - 2, size);
            this.line1 = null;
            this.line2 = null;
        }
    }

    @OnThread(value=Tag.Any)
    public boolean isSelected() {
        return this.selected;
    }

    @OnThread(value=Tag.FXPlatform)
    public int getX() {
        Double leftAnchor = AnchorPane.getLeftAnchor((Node)this.pane);
        if (leftAnchor == null) {
            return 0;
        }
        return (int)leftAnchor.doubleValue();
    }

    @OnThread(value=Tag.FXPlatform)
    public int getY() {
        Double topAnchor = AnchorPane.getTopAnchor((Node)this.pane);
        if (topAnchor == null) {
            return 0;
        }
        return (int)topAnchor.doubleValue();
    }

    @OnThread(value=Tag.FXPlatform)
    public int getWidth() {
        return (int)this.pane.getPrefWidth();
    }

    @OnThread(value=Tag.FXPlatform)
    public int getHeight() {
        return (int)this.pane.getPrefHeight();
    }

    public boolean isQueued() {
        return this.queued;
    }

    public void setQueued(boolean queued) {
        this.queued = queued;
    }

    @OnThread(value=Tag.FX)
    public boolean isResizable() {
        return this.resizable;
    }

    @OnThread(value=Tag.FXPlatform)
    public void setResizable(boolean resizable) {
        this.resizable = resizable;
    }

    @OnThread(value=Tag.Any)
    public boolean isSaveable() {
        return true;
    }

    public boolean isSelectable() {
        return true;
    }

    @OnThread(value=Tag.FXPlatform)
    public void repaint() {
        Package thePkg = this.getPackage();
        if (thePkg != null) {
            thePkg.repaint();
        }
    }

    @OnThread(value=Tag.Any)
    public boolean equals(Object o) {
        if (o instanceof Target) {
            Target t = (Target)o;
            return this.identifierName.equals(t.identifierName);
        }
        return false;
    }

    @OnThread(value=Tag.Any)
    public synchronized int hashCode() {
        return this.identifierName.hashCode();
    }

    @Override
    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public @OnThread(value=Tag.FXPlatform, ignoreParent=true) int compareTo(Target t) {
        if (this.equals(t)) {
            return 0;
        }
        if (this.getY() < t.getY()) {
            return -1;
        }
        if (this.getY() > t.getY()) {
            return 1;
        }
        if (this.getX() < t.getX()) {
            return -1;
        }
        if (this.getX() > t.getX()) {
            return 1;
        }
        return this.identifierName.compareTo(t.getIdentifierName());
    }

    public String toString() {
        return this.getDisplayName();
    }

    @OnThread(value=Tag.FXPlatform)
    public void setPos(int x, int y) {
        AnchorPane.setTopAnchor((Node)this.pane, (Double)Double.valueOf(y));
        AnchorPane.setLeftAnchor((Node)this.pane, (Double)Double.valueOf(x));
        this.repaint();
    }

    @OnThread(value=Tag.FXPlatform)
    public void setSize(int width, int height) {
        this.pane.setPrefWidth((double)width);
        this.pane.setPrefHeight((double)height);
        this.repaint();
        this.redraw();
    }

    @OnThread(value=Tag.FXPlatform)
    public abstract void doubleClick(boolean var1);

    public abstract void remove();

    @OnThread(value=Tag.FXPlatform)
    public Node getNode() {
        return this.pane;
    }

    @OnThread(value=Tag.FXPlatform)
    public boolean isMoveable() {
        return true;
    }

    @OnThread(value=Tag.FXPlatform)
    public boolean isFront() {
        return true;
    }

    @OnThread(value=Tag.FXPlatform)
    public Bounds getBoundsInEditor() {
        return this.pane.getBoundsInParent();
    }

    @OnThread(value=Tag.FXPlatform)
    public void savePreMovePosition() {
        this.preMoveX = this.getX();
        this.preMoveY = this.getY();
    }

    @OnThread(value=Tag.FXPlatform)
    public int getPreMoveX() {
        return this.preMoveX;
    }

    @OnThread(value=Tag.FXPlatform)
    public int getPreMoveY() {
        return this.preMoveY;
    }

    @OnThread(value=Tag.FXPlatform)
    public void savePreResize() {
        this.preResizeWidth = this.getWidth();
        this.preResizeHeight = this.getHeight();
    }

    @OnThread(value=Tag.FXPlatform)
    public int getPreResizeWidth() {
        return this.preResizeWidth;
    }

    @OnThread(value=Tag.FXPlatform)
    public int getPreResizeHeight() {
        return this.preResizeHeight;
    }

    @OnThread(value=Tag.FXPlatform)
    protected final void showingMenu(ContextMenu newMenu) {
        if (newMenu != null) {
            this.requestFocus();
        }
        if (this.showingContextMenu != null) {
            this.showingContextMenu.hide();
        }
        this.showingContextMenu = newMenu;
    }

    @OnThread(value=Tag.FXPlatform)
    private static boolean isArrowKey(KeyEvent evt) {
        return evt.getCode() == KeyCode.UP || evt.getCode() == KeyCode.DOWN || evt.getCode() == KeyCode.LEFT || evt.getCode() == KeyCode.RIGHT;
    }

    @OnThread(value=Tag.FXPlatform)
    public boolean isFocused() {
        return this.pane.isFocused();
    }

    @OnThread(value=Tag.FXPlatform)
    public void requestFocus() {
        this.pane.requestFocus();
    }

    @OnThread(value=Tag.FXPlatform)
    public void setCreatingExtends(boolean drawingExtends) {
        this.pane.setEffect((Effect)(drawingExtends ? new ColorAdjust(0.0, 0.0, -0.2, 0.0) : null));
    }
}

