/*
 * Decompiled with CFR 0.152.
 */
package bluej.runtime;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;

public class UnitTestExtension
implements InvocationInterceptor {
    private static ArrayList<String> argsAsStrList = new ArrayList();

    private void doIntereceptionMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        argsAsStrList.clear();
        List args = invocationContext.getArguments();
        for (Object arg : args) {
            argsAsStrList.add(this.getArgStrRepresentation(arg));
        }
        invocation.proceed();
    }

    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.doIntereceptionMethod(invocation, invocationContext, extensionContext);
    }

    public void interceptTestTemplateMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.doIntereceptionMethod(invocation, invocationContext, extensionContext);
    }

    private String getArgStrRepresentation(Object arg) {
        if (arg == null) {
            return "null";
        }
        if (arg instanceof Number || arg instanceof Boolean) {
            return arg.toString();
        }
        if (arg instanceof CharSequence) {
            return "\"" + arg.toString() + "\"";
        }
        if (arg instanceof Character) {
            return "'" + arg.toString() + "'";
        }
        if (arg instanceof Iterable || arg.getClass().isArray()) {
            ArrayList<String> arrayElementsStrList = new ArrayList<String>();
            if (arg instanceof Iterable) {
                ((Iterable)arg).forEach(o -> arrayElementsStrList.add(this.getArgStrRepresentation(o)));
            } else {
                int arraySize = Array.getLength(arg);
                for (int arrayIndex = 0; arrayIndex < arraySize; ++arrayIndex) {
                    arrayElementsStrList.add(this.getArgStrRepresentation(Array.get(arg, arrayIndex)));
                }
            }
            return "[" + String.join((CharSequence)", ", arrayElementsStrList) + "]";
        }
        return arg.getClass().getCanonicalName() + " " + arg.toString();
    }

    public static ArrayList<String> getArgsAsStrList() {
        return argsAsStrList;
    }
}

