/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.convert;

import bluej.Config;
import threadchecker.OnThread;
import threadchecker.Tag;

public abstract class ConversionWarning {
    private final String text;

    private ConversionWarning(String labelId, String item) {
        this.text = Config.getString(labelId).trim() + " " + item;
    }

    public String getMessage() {
        return this.text;
    }

    public String toString() {
        return String.valueOf(this.getClass()) + "[" + this.text + "]";
    }

    @OnThread(value=Tag.Any)
    public static class UnsupportedFeature
    extends ConversionWarning {
        public UnsupportedFeature(String feature) {
            super("stride.convert.unsupported.feature", ": " + feature);
        }
    }

    @OnThread(value=Tag.Any)
    public static class UnsupportedModifier
    extends ConversionWarning {
        public UnsupportedModifier(String context, String modifier) {
            super("stride.convert.unsupported.modifier", context + ": " + modifier);
        }
    }
}

