/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.elements;

import bluej.stride.framedjava.ast.FilledExpressionSlotFragment;
import bluej.stride.framedjava.ast.HighlightedBreakpoint;
import bluej.stride.framedjava.ast.JavaSingleLineDebugHandler;
import bluej.stride.framedjava.ast.JavaSource;
import bluej.stride.framedjava.ast.SlotFragment;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.LocatableElement;
import bluej.stride.framedjava.frames.AssignFrame;
import bluej.stride.framedjava.frames.DebugInfo;
import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import java.util.stream.Stream;
import nu.xom.Element;

public class AssignElement
extends CodeElement
implements JavaSingleLineDebugHandler {
    public static final String ELEMENT = "assign";
    private final FilledExpressionSlotFragment lhs;
    private final FilledExpressionSlotFragment rhs;
    private AssignFrame frame;

    public AssignElement(AssignFrame frame, FilledExpressionSlotFragment lhs, FilledExpressionSlotFragment rhs, boolean enabled) {
        this.frame = frame;
        this.lhs = lhs;
        this.lhs.markAssignmentLHS(frame);
        this.rhs = rhs;
        this.enable = enabled;
    }

    @Override
    public JavaSource toJavaSource() {
        return new JavaSource((JavaSingleLineDebugHandler)this, this.lhs, this.f(this.frame, " = "), this.rhs, this.f(this.frame, ";"));
    }

    @Override
    public LocatableElement toXML() {
        LocatableElement assignEl = new LocatableElement(this, ELEMENT);
        assignEl.addAttributeStructured("dest", this.lhs);
        assignEl.addAttributeStructured("src", this.rhs);
        this.addEnableAttribute(assignEl);
        return assignEl;
    }

    public AssignElement(Element el) {
        this.lhs = new FilledExpressionSlotFragment(el.getAttributeValue("dest"), el.getAttributeValue("dest-java"));
        this.rhs = new FilledExpressionSlotFragment(el.getAttributeValue("src"), el.getAttributeValue("src-java"));
        this.enable = Boolean.valueOf(el.getAttributeValue("enable"));
    }

    @Override
    public Frame createFrame(InteractionManager editor) {
        this.frame = new AssignFrame(editor, this.lhs, this.rhs, this.isEnable());
        this.lhs.markAssignmentLHS(this.frame);
        return this.frame;
    }

    @Override
    public HighlightedBreakpoint showDebugBefore(DebugInfo debug) {
        return this.frame.showDebugBefore(debug);
    }

    @Override
    public void show(Frame.ShowReason reason) {
        this.frame.show(reason);
    }

    @Override
    protected Stream<SlotFragment> getDirectSlotFragments() {
        return Stream.of(this.lhs, this.rhs);
    }
}

