/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.elements;

import bluej.stride.framedjava.ast.CallExpressionSlotFragment;
import bluej.stride.framedjava.ast.HighlightedBreakpoint;
import bluej.stride.framedjava.ast.JavaSingleLineDebugHandler;
import bluej.stride.framedjava.ast.JavaSource;
import bluej.stride.framedjava.ast.SlotFragment;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.LocatableElement;
import bluej.stride.framedjava.frames.CallFrame;
import bluej.stride.framedjava.frames.DebugInfo;
import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import java.util.stream.Stream;
import nu.xom.Element;

public class CallElement
extends CodeElement
implements JavaSingleLineDebugHandler {
    public static final String ELEMENT = "call";
    private final CallExpressionSlotFragment call;
    private CallFrame frame;

    public CallElement(CallFrame frame, CallExpressionSlotFragment call, boolean enabled) {
        this.frame = frame;
        this.call = call;
        this.enable = enabled;
    }

    public CallElement(Element el) {
        this.call = new CallExpressionSlotFragment(el.getAttributeValue("expression"), el.getAttributeValue("expression-java"));
        this.enable = Boolean.valueOf(el.getAttributeValue("enable"));
    }

    public CallElement(String call, String javaCode) {
        this.call = new CallExpressionSlotFragment(call, javaCode);
    }

    @Override
    public JavaSource toJavaSource() {
        return new JavaSource((JavaSingleLineDebugHandler)this, this.call, this.f(this.frame, ";"));
    }

    @Override
    public LocatableElement toXML() {
        LocatableElement callEl = new LocatableElement(this, ELEMENT);
        callEl.addAttributeStructured("expression", this.call);
        this.addEnableAttribute(callEl);
        return callEl;
    }

    @Override
    public Frame createFrame(InteractionManager editor) {
        this.frame = new CallFrame(editor, this.call, this.isEnable());
        return this.frame;
    }

    @Override
    public HighlightedBreakpoint showDebugBefore(DebugInfo debug) {
        return this.frame.showDebugBefore(debug);
    }

    @Override
    public void show(Frame.ShowReason reason) {
        this.frame.show(reason);
    }

    @Override
    protected Stream<SlotFragment> getDirectSlotFragments() {
        return Stream.of(this.call);
    }
}

