/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.elements;

import bluej.stride.framedjava.ast.AccessPermission;
import bluej.stride.framedjava.ast.AccessPermissionFragment;
import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.ast.JavaSingleLineDebugHandler;
import bluej.stride.framedjava.ast.JavaSource;
import bluej.stride.framedjava.ast.JavadocUnit;
import bluej.stride.framedjava.ast.ParamFragment;
import bluej.stride.framedjava.ast.SlotFragment;
import bluej.stride.framedjava.ast.SuperThis;
import bluej.stride.framedjava.ast.SuperThisFragment;
import bluej.stride.framedjava.ast.SuperThisParamsExpressionFragment;
import bluej.stride.framedjava.ast.ThrowsTypeFragment;
import bluej.stride.framedjava.elements.ClassElement;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.LocatableElement;
import bluej.stride.framedjava.elements.MethodWithBodyElement;
import bluej.stride.framedjava.frames.ConstructorFrame;
import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import nu.xom.Element;
import nu.xom.Node;

public class ConstructorElement
extends MethodWithBodyElement {
    public static final String ELEMENT = "constructor";
    private final SuperThisFragment delegate;
    private final SuperThisParamsExpressionFragment delegateParams;

    public ConstructorElement(ConstructorFrame frame, AccessPermissionFragment access, List<ParamFragment> params, List<ThrowsTypeFragment> throwsTypes, SuperThisFragment delegate, SuperThisParamsExpressionFragment delegateParams, List<CodeElement> contents, JavadocUnit documentation, boolean enabled) {
        super(frame, access, params, throwsTypes, contents, documentation, enabled);
        this.delegate = delegate;
        this.delegateParams = delegateParams;
    }

    public ConstructorElement(String javaDoc) {
        this(null, new AccessPermissionFragment(AccessPermission.PUBLIC), Collections.emptyList(), Collections.emptyList(), null, null, Collections.emptyList(), new JavadocUnit(javaDoc), true);
    }

    public ConstructorElement(Element el) {
        super(el);
        SuperThisFragment loadedDelegate = null;
        SuperThisParamsExpressionFragment loadedDelegateParams = null;
        for (int i = 0; i < el.getChildElements().size(); ++i) {
            String target;
            Element section = el.getChildElements().get(i);
            if (!section.getLocalName().equals("delegate")) continue;
            switch (target = section.getAttributeValue("target")) {
                case "super": 
                case "this": {
                    loadedDelegate = new SuperThisFragment(SuperThis.fromString(target));
                    loadedDelegateParams = new SuperThisParamsExpressionFragment(section.getAttributeValue("params"), section.getAttributeValue("params-java"));
                }
            }
        }
        this.delegate = loadedDelegate;
        this.delegateParams = loadedDelegateParams;
    }

    @Override
    public JavaSource toJavaSource() {
        ArrayList<JavaFragment> header = new ArrayList<JavaFragment>();
        Collections.addAll(header, this.access, this.space(), ((ClassElement)this.getParent()).getNameElement((ConstructorFrame)this.frame), this.f(this.frame, "("));
        ParamFragment.addParamsToHeader(this.frame, this, this.params, header);
        header.add(this.f(this.frame, ")"));
        header.addAll(this.throwsToJava());
        ArrayList<JavaSource> effectiveContents = new ArrayList<JavaSource>();
        if (this.delegate != null) {
            effectiveContents.add(new JavaSource((JavaSingleLineDebugHandler)this, this.delegate, this.f(this.frame, "("), this.delegateParams, this.f(this.frame, ");")));
        }
        effectiveContents.addAll(CodeElement.toJavaCodes(this.contents));
        return JavaSource.createMethod(this.frame, this, this, this.documentation, header, effectiveContents);
    }

    @Override
    public LocatableElement toXML() {
        LocatableElement methodEl = new LocatableElement(this, ELEMENT);
        this.accessToXML(methodEl);
        this.addEnableAttribute(methodEl);
        methodEl.appendChild((Node)this.documentation.toXML());
        this.paramsToXML(methodEl);
        this.throwsToXML(methodEl);
        if (this.delegate != null) {
            LocatableElement delegateEl = new LocatableElement(null, "delegate");
            delegateEl.addAttributeSuperThis("target", this.delegate);
            delegateEl.addAttributeStructured("params", this.delegateParams);
            methodEl.appendChild((Node)delegateEl);
        }
        this.bodyToXML(methodEl);
        return methodEl;
    }

    @Override
    public Frame createFrame(InteractionManager editor) {
        this.frame = new ConstructorFrame(editor, this.access, this.documentation.toString(), this.delegate, this.delegateParams, this.isEnable());
        this.setupFrame(editor);
        return this.frame;
    }

    @Override
    public String getType() {
        return null;
    }

    @Override
    public void show(Frame.ShowReason reason) {
        this.frame.show(reason);
    }

    @Override
    protected Stream<SlotFragment> getDirectSlotFragments() {
        Stream<Object> s = this.params.stream().flatMap(p -> Stream.of(p.getParamType(), p.getParamName()));
        if (this.delegate != null) {
            s = Stream.concat(s, Stream.of(this.delegateParams));
        }
        return Stream.concat(s, this.throwsTypes.stream().map(ThrowsTypeFragment::getJavaSource));
    }

    public boolean hasDelegate() {
        return this.delegate != null;
    }

    public SuperThis getDelegate() {
        return this.delegate == null ? null : this.delegate.getValue();
    }

    public String getDelegateParams() {
        return this.delegateParams == null ? null : this.delegateParams.getContent();
    }

    public String getDelegateParamsJava() {
        return this.delegateParams == null ? null : this.delegateParams.getJavaCode();
    }
}

