/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.errors;

import bluej.Config;
import bluej.compiler.Diagnostic;
import bluej.editor.fixes.Correction;
import bluej.editor.fixes.EditorFixesManager;
import bluej.editor.fixes.FixSuggestion;
import bluej.parser.AssistContentThreadSafe;
import bluej.stride.framedjava.ast.SlotFragment;
import bluej.stride.framedjava.errors.DirectSlotError;
import bluej.stride.generic.InteractionManager;
import bluej.utility.javafx.FXPlatformConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.application.Platform;
import threadchecker.OnThread;
import threadchecker.Tag;

public class UnknownTypeError
extends DirectSlotError {
    private final String typeName;
    private final InteractionManager editor;
    private final List<FixSuggestion> corrections = new ArrayList<FixSuggestion>();

    @OnThread(value=Tag.Any)
    public UnknownTypeError(SlotFragment slotFragment, String typeName, FXPlatformConsumer<Correction.CorrectionElements> replace, InteractionManager editor, Stream<AssistContentThreadSafe> possibleCorrections, Stream<AssistContentThreadSafe> possibleImports) {
        super(slotFragment, Diagnostic.DiagnosticOrigin.STRIDE_LATE);
        this.typeName = typeName;
        this.editor = editor;
        List possibleImportsList = possibleImports.collect(Collectors.toList());
        List possibleCorrectionsList = possibleCorrections.collect(Collectors.toList());
        possibleCorrectionsList.addAll(possibleImportsList.stream().filter(ac -> Correction.isClassInUsualPackagesForCorrections(ac) && !possibleCorrectionsList.contains(ac)).collect(Collectors.toList()));
        Platform.runLater(() -> this.corrections.addAll(Correction.winnowAndCreateCorrections(typeName, possibleCorrectionsList.stream().map(Correction.TypeCorrectionInfo::new), replace, true)));
        this.corrections.addAll(possibleImportsList.stream().filter(ac -> ac.getPackage() != null && ac.getName().equals(typeName) && ac.getDeclaringClass() == null).flatMap(ac -> Stream.of(new EditorFixesManager.FixSuggestionBase(Config.getString("editor.quickfix.unknownType.fixMsg.class") + ac.getPackage() + "." + ac.getName(), () -> editor.getFrameEditor().addImportFromQuickFix(ac.getPackage() + "." + ac.getName())), new EditorFixesManager.FixSuggestionBase(Config.getString("editor.quickfix.unknownType.fixMsg.package") + ac.getPackage() + " (for " + ac.getName() + " class)", () -> editor.getFrameEditor().addImportFromQuickFix(ac.getPackage() + ".*")))).collect(Collectors.toList()));
    }

    @Override
    @OnThread(value=Tag.Any)
    public String getMessage() {
        return Config.getString("editor.quickfix.unknownType.errorMsg") + this.typeName;
    }

    @Override
    public List<? extends FixSuggestion> getFixSuggestions() {
        return this.corrections;
    }

    @Override
    public boolean isJavaPos() {
        return true;
    }
}

