/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.frames;

import bluej.stride.framedjava.elements.BlankElement;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.generic.CanvasParent;
import bluej.stride.generic.DefaultFrameFactory;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameFactory;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.SingleLineFrame;

public class BlankFrame
extends SingleLineFrame
implements CodeFrame<BlankElement> {
    private final BlankElement blankElement = new BlankElement();

    public BlankFrame(InteractionManager editor) {
        super(editor, "", "blank-");
        this.frameName = "blank line";
    }

    @Override
    public String getScreenReaderHelp() {
        return "you are " + this.getParentCanvas().getParentLocationDescription();
    }

    @Override
    public void regenerateCode() {
    }

    @Override
    public BlankElement getCode() {
        return this.blankElement;
    }

    @Override
    public void setElementEnabled(boolean enabled) {
    }

    @Override
    public boolean canHaveEnabledState(boolean enabled) {
        return enabled;
    }

    public static FrameFactory<BlankFrame> getFactory() {
        return new DefaultFrameFactory<BlankFrame>(BlankFrame.class, BlankFrame::new);
    }

    @Override
    public void updateAppearance(FrameCanvas parentCanvas) {
        super.updateAppearance(parentCanvas);
        if (parentCanvas == null) {
            return;
        }
        if (parentCanvas.getParent().getChildKind(parentCanvas) == CanvasParent.CanvasKind.FIELDS) {
            this.addStyleClass(this.isInInterface(parentCanvas) ? "interface-blank-frame" : "class-blank-frame");
        } else {
            this.removeStyleClass(this.isInInterface(parentCanvas) ? "interface-blank-frame" : "class-blank-frame");
        }
    }

    @Override
    protected void saveAsRecent() {
    }

    @Override
    public boolean isEffectiveFrame() {
        return false;
    }
}

