/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.frames;

import bluej.Config;
import bluej.stride.framedjava.ast.ExpressionSlotFragment;
import bluej.stride.framedjava.ast.FilledExpressionSlotFragment;
import bluej.stride.framedjava.ast.HighlightedBreakpoint;
import bluej.stride.framedjava.canvases.JavaCanvas;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.SwitchElement;
import bluej.stride.framedjava.frames.BlankFrame;
import bluej.stride.framedjava.frames.BreakFrame;
import bluej.stride.framedjava.frames.CaseFrame;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.framedjava.frames.DebugInfo;
import bluej.stride.framedjava.frames.DebuggableParentFrame;
import bluej.stride.framedjava.frames.StrideCategory;
import bluej.stride.framedjava.frames.StrideDictionary;
import bluej.stride.framedjava.slots.ExpressionSlot;
import bluej.stride.framedjava.slots.FilledExpressionSlot;
import bluej.stride.generic.ExtensionDescription;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameContentRow;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.FrameFactory;
import bluej.stride.generic.FrameTypeCheck;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.MultiCanvasFrame;
import bluej.stride.operations.PullUpContentsOperation;
import bluej.stride.slots.EditableSlot;
import bluej.stride.slots.SlotLabel;
import bluej.utility.Debug;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.css.Styleable;
import threadchecker.OnThread;
import threadchecker.Tag;

public class SwitchFrame
extends MultiCanvasFrame
implements CodeFrame<SwitchElement>,
DebuggableParentFrame {
    private static final String SWITCH_STYLE_PREFIX = "switch-";
    private final ExpressionSlot<FilledExpressionSlotFragment> expression;
    private final JavaCanvas casesCanvas;
    private JavaCanvas defaultCanvas;
    private SwitchElement element;
    private final InteractionManager editor;
    private SlotLabel defaultLabel = new SlotLabel("default", new String[0]);

    private SwitchFrame(InteractionManager editor) {
        super(editor, "switch", SWITCH_STYLE_PREFIX);
        this.editor = editor;
        this.casesCanvas = new JavaCanvas(editor, this, SWITCH_STYLE_PREFIX, false);
        this.addCanvas(null, this.casesCanvas);
        this.expression = new FilledExpressionSlot(this, editor, this, this, this.getHeaderRow(), SWITCH_STYLE_PREFIX){

            @Override
            @OnThread(value=Tag.FXPlatform)
            public boolean backspaceAtStart() {
                if (this.isAlmostBlank()) {
                    new PullUpContentsOperation(this.editor).activate(this.getParentFrame());
                    return true;
                }
                return super.backspaceAtStart();
            }
        };
        this.expression.setSimplePromptText("expression");
        this.setHeaderRow(new SlotLabel("(", new String[0]), this.expression, new SlotLabel(")", new String[0]));
        this.expression.onTextPropertyChange(this.updateSidebarCurried("switch "));
    }

    public SwitchFrame(InteractionManager editor, ExpressionSlotFragment expression, boolean enabled) {
        this(editor);
        this.expression.setText(expression);
        this.frameEnabledProperty.set(enabled);
        this.frameName = "switch block" + this.expression.getScreenreaderText();
        this.expression.setSlotName("switch statement expression");
    }

    @Override
    public String getScreenReaderText(Frame.View viewMode) {
        return this.frameName + " with condition " + this.expression.getScreenreaderText();
    }

    @Override
    public String getScreenReaderHelp() {
        return "you are " + this.getParentCanvas().getParentLocationDescription();
    }

    @Override
    public String getLocationDescription(FrameCanvas c) {
        String expressionStr = this.expression.getText().equals("") ? "blank" : this.expression.getText();
        String text = " in a 'switch' frame for expression " + expressionStr + ",";
        if (this.getParentCanvas() != null && this.getParentCanvas().getParent() != null) {
            text = text + this.getParentCanvas().getParentLocationDescription();
        }
        return text;
    }

    public boolean addDefault() {
        if (this.defaultCanvas != null) {
            return false;
        }
        this.defaultCanvas = new JavaCanvas(this.editor, this, "default-case-", false);
        JavaFXUtil.addStyleClass((Styleable)this.defaultLabel, "divider-default-case");
        this.addCanvas(new FrameContentRow((Frame)this, this.defaultLabel), this.defaultCanvas);
        this.defaultCanvas.getFirstCursor().requestFocus();
        this.editor.modifiedFrame(this, false);
        return true;
    }

    private void removeDefault() {
        if (this.defaultCanvas != null) {
            this.removeCanvas(this.defaultCanvas);
            this.defaultCanvas = null;
            this.editor.modifiedFrame(this, false);
        }
    }

    public static FrameFactory<SwitchFrame> getFactory() {
        return new FrameFactory<SwitchFrame>(){

            @Override
            public SwitchFrame createBlock(InteractionManager editor) {
                SwitchFrame switchFrame = new SwitchFrame(editor);
                switchFrame.getFirstInternalCursor().insertBlockAfter(CaseFrame.getFactory().createBlock(editor));
                return switchFrame;
            }

            @Override
            public Class<SwitchFrame> getBlockClass() {
                return SwitchFrame.class;
            }
        };
    }

    @Override
    public void pullUpContents() {
        ArrayList<Frame> casesFrames = new ArrayList<Frame>((Collection<Frame>)this.casesCanvas.getBlockContents());
        casesFrames.forEach(c -> this.casesCanvas.removeBlock((Frame)c));
        ArrayList<Frame> contents = new ArrayList<Frame>();
        boolean previousCaseIsEmpty = true;
        for (Frame caseFrame : casesFrames) {
            List<Frame> caseFrameContent = ((CaseFrame)caseFrame).getValidPulledStatements();
            caseFrameContent.forEach(child -> ((CaseFrame)caseFrame).getCanvas().removeBlock((Frame)child));
            if (!previousCaseIsEmpty && caseFrameContent.size() > 0) {
                contents.add(new BlankFrame(this.editor));
            }
            contents.addAll(caseFrameContent);
            previousCaseIsEmpty = contents.isEmpty();
        }
        this.getCursorBefore().insertFramesAfter(contents);
        if (this.defaultCanvas != null) {
            ArrayList<Frame> defaultContents = new ArrayList<Frame>((Collection<Frame>)this.defaultCanvas.getBlockContents());
            defaultContents.forEach(c -> this.defaultCanvas.removeBlock((Frame)c));
            if (!previousCaseIsEmpty && defaultContents.stream().anyMatch(f -> !(f instanceof BreakFrame))) {
                defaultContents.add(0, new BlankFrame(this.editor));
            }
            this.getCursorBefore().insertFramesAfter(defaultContents);
        }
        this.editor.modifiedFrame(this, false);
    }

    public void pullUpInnerCaseContents(CaseFrame frame) {
        int index = this.casesCanvas.getBlockContents().indexOf((Object)frame);
        if (index < 0) {
            throw new IllegalStateException("CaseFrame should be in the casesCanvas");
        }
        if (index == 0) {
            Debug.message("pullUpInnerCaseContents @ SwitchFrame: Unimplemented case, waiting a design decision");
        } else {
            List<Frame> contents = frame.getValidPulledStatements();
            contents.forEach(child -> frame.getCanvas().removeBlock((Frame)child));
            CaseFrame previous = (CaseFrame)this.casesCanvas.getBlockContents().get(index - 1);
            FrameCursor previousCursor = previous.getLastInternalCursor();
            previousCursor.insertFramesAfter(contents);
            if (previousCursor.getCursorIndex() > 0 && contents.size() > 0) {
                previousCursor.insertBlockAfter(new BlankFrame(this.getEditor()));
            }
            this.casesCanvas.removeBlock(frame);
            previousCursor.requestFocus();
        }
        this.editor.modifiedFrame(this, false);
    }

    private void pullUpDefaultContents() {
        if (this.defaultCanvas == null) {
            throw new IllegalStateException("Default couldn't be null if this method is invoked.");
        }
        int casesCount = this.casesCanvas.blockCount();
        if (casesCount == 0) {
            Debug.message("pullUpDefaultContents @ SwitchFrame: Unimplemented case, waiting a design decision");
        } else {
            ArrayList<Frame> defaultContents = new ArrayList<Frame>((Collection<Frame>)this.defaultCanvas.getBlockContents());
            defaultContents.forEach(c -> this.defaultCanvas.removeBlock((Frame)c));
            CaseFrame previous = (CaseFrame)this.casesCanvas.getBlockContents().get(casesCount - 1);
            FrameCursor previousCursor = previous.getLastInternalCursor();
            previousCursor.insertFramesAfter(defaultContents);
            if (previousCursor.getCursorIndex() > 0 && defaultContents.stream().anyMatch(f -> !(f instanceof BreakFrame))) {
                previousCursor.insertBlockAfter(new BlankFrame(this.getEditor()));
            }
            this.removeDefault();
            previousCursor.requestFocus();
        }
        this.editor.modifiedFrame(this, false);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public HighlightedBreakpoint showDebugAtEnd(DebugInfo debug) {
        return this.getCasesCanvas().showDebugBefore(null, debug);
    }

    @Override
    public void regenerateCode() {
        ArrayList casesContents = new ArrayList();
        this.casesCanvas.getBlocksSubtype(CodeFrame.class).forEach(f -> {
            f.regenerateCode();
            casesContents.add(f.getCode());
        });
        ArrayList<CodeElement> defaultContents = null;
        if (this.defaultCanvas != null) {
            defaultContents = new ArrayList<CodeElement>();
            for (CodeFrame f2 : this.defaultCanvas.getBlocksSubtype(CodeFrame.class)) {
                f2.regenerateCode();
                defaultContents.add((CodeElement)f2.getCode());
            }
        }
        this.element = new SwitchElement(this, (FilledExpressionSlotFragment)this.expression.getSlotElement(), casesContents, defaultContents, this.frameEnabledProperty.get());
    }

    @Override
    public SwitchElement getCode() {
        return this.element;
    }

    @Override
    public BreakFrame.BreakEncloser asBreakEncloser() {
        return BreakFrame.BreakEncloser.SWITCH;
    }

    public JavaCanvas getCasesCanvas() {
        return this.casesCanvas;
    }

    public JavaCanvas getDefaultCanvas() {
        return this.defaultCanvas;
    }

    public DebuggableParentFrame getCasesDebug() {
        return new DebuggableParentFrame(){

            @Override
            @OnThread(value=Tag.FXPlatform)
            public HighlightedBreakpoint showDebugBefore(DebugInfo debug) {
                return ((JavaCanvas)this.getParentCanvas()).showDebugBefore(SwitchFrame.this, debug);
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public HighlightedBreakpoint showDebugAtEnd(DebugInfo debug) {
                return SwitchFrame.this.getCasesCanvas().showDebugBefore(null, debug);
            }

            @Override
            public FrameCanvas getParentCanvas() {
                return SwitchFrame.this.getParentCanvas();
            }
        };
    }

    public DebuggableParentFrame getDefaultDebug() {
        return new DebuggableParentFrame(){

            @Override
            @OnThread(value=Tag.FXPlatform)
            public HighlightedBreakpoint showDebugBefore(DebugInfo debug) {
                return ((JavaCanvas)this.getParentCanvas()).showDebugBefore(SwitchFrame.this, debug);
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public HighlightedBreakpoint showDebugAtEnd(DebugInfo debug) {
                return SwitchFrame.this.getDefaultCanvas().showDebugBefore(null, debug);
            }

            @Override
            public FrameCanvas getParentCanvas() {
                return SwitchFrame.this.getParentCanvas();
            }
        };
    }

    @Override
    public boolean focusWhenJustAdded() {
        this.expression.requestFocus();
        return true;
    }

    @Override
    public FrameTypeCheck check(FrameCanvas canvas) {
        if (canvas == this.casesCanvas) {
            return new FrameTypeCheck(this){

                @Override
                public boolean canInsert(StrideCategory category) {
                    return category == StrideCategory.CASE;
                }

                @Override
                public boolean canPlace(Class<? extends Frame> type) {
                    return type.equals(CaseFrame.class);
                }
            };
        }
        if (canvas == this.defaultCanvas) {
            return StrideDictionary.checkStatement();
        }
        throw new IllegalStateException("Asking about unknown child of SwitchFrame");
    }

    @Override
    public List<ExtensionDescription> getAvailableExtensions(FrameCanvas canvas, FrameCursor cursorInCanvas) {
        ArrayList<ExtensionDescription> result = new ArrayList<ExtensionDescription>(super.getAvailableExtensions(canvas, cursorInCanvas));
        if (this.defaultCanvas == null) {
            result.add(new ExtensionDescription('d', "Add default", this::addDefault, true, ExtensionDescription.ExtensionSource.INSIDE_FIRST, ExtensionDescription.ExtensionSource.INSIDE_LATER, ExtensionDescription.ExtensionSource.AFTER));
        }
        if (canvas == this.casesCanvas) {
            result.add(new ExtensionDescription('\b', Config.getString("frame.switch.remove.switch"), () -> new PullUpContentsOperation(this.editor).activate(this.getFrame()), false, ExtensionDescription.ExtensionSource.INSIDE_FIRST, new ExtensionDescription.ExtensionSource[0]));
        }
        if (this.defaultCanvas != null && canvas == this.defaultCanvas) {
            result.add(new ExtensionDescription('\b', Config.getString("frame.switch.remove.default"), this::pullUpDefaultContents, false, ExtensionDescription.ExtensionSource.INSIDE_FIRST, new ExtensionDescription.ExtensionSource[0]));
        }
        return result;
    }

    @Override
    public boolean isAlmostBlank() {
        return this.getEditableSlotsDirect().allMatch(EditableSlot::isAlmostBlank) && this.defaultCanvas == null && (this.casesCanvas.blockCount() == 0 || this.casesCanvas.blockCount() == 1 && ((Frame)this.casesCanvas.getBlockContents().get(0)).isAlmostBlank());
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void setView(Frame.View oldView, Frame.View newView, SharedTransition animate) {
        boolean java;
        super.setView(oldView, newView, animate);
        JavaFXUtil.setPseudoclass("bj-java-preview", newView == Frame.View.JAVA_PREVIEW, this.sidebar.getStyleable());
        boolean bl = java = newView == Frame.View.JAVA_PREVIEW;
        if (this.isFrameEnabled() && (java || oldView == Frame.View.JAVA_PREVIEW)) {
            if (this.defaultCanvas != null) {
                this.casesCanvas.previewCurly(java, true, false, this.header.getLeftFirstItem(), null, animate);
                this.defaultCanvas.previewCurly(java, false, true, this.header.getLeftFirstItem(), null, animate);
            } else {
                this.casesCanvas.previewCurly(java, this.header.getLeftFirstItem(), null, animate);
            }
        }
        this.getCanvases().forEach(c -> {
            c.getCursors().forEach(cur -> cur.setView(newView, animate));
            c.setView(oldView, newView, animate);
        });
        this.defaultLabel.setText(newView == Frame.View.JAVA_PREVIEW ? "default :" : "default");
    }

    @Override
    public void updateAppearance(FrameCanvas parentCanvas) {
        super.updateAppearance(parentCanvas);
        if (this.getParentCanvas() != null && this.getParentCanvas().getParent() != null) {
            this.expression.setAccessibilityHelpSlots();
        }
    }

    @Override
    public String getHelpContext() {
        String parent = "";
        if (this.getParentCanvas() != null && this.getParentCanvas().getParent() != null) {
            parent = this.getParentCanvas().getParent().getHelpContext();
        }
        return "in switch statement " + parent;
    }
}

