/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.generic;

import bluej.stride.generic.Frame;
import bluej.stride.operations.ToggleBooleanProperty;
import bluej.utility.Debug;
import bluej.utility.javafx.FXPlatformRunnable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import threadchecker.OnThread;
import threadchecker.Tag;

public class ExtensionDescription {
    private final char shortcut;
    private final String description;
    private final boolean showInCatalogue;
    private final List<ExtensionSource> validSources;
    private FXPlatformRunnable action;
    private ToggleBooleanProperty operation;
    private Frame frame;

    public ExtensionDescription(char shortcut, String description, FXPlatformRunnable action, boolean showInCatalogue, ExtensionSource firstSrc, ExtensionSource ... restSrc) {
        this(shortcut, description, showInCatalogue, firstSrc, restSrc);
        this.action = action;
    }

    public ExtensionDescription(ToggleBooleanProperty operation, Frame frame, boolean showInCatalogue, ExtensionSource firstSrc, ExtensionSource ... restSrc) {
        this(operation.getKey(), operation.getLabel(), showInCatalogue, firstSrc, restSrc);
        this.operation = operation;
        this.frame = frame;
    }

    private ExtensionDescription(char shortcut, String description, boolean showInCatalogue, ExtensionSource firstSrc, ExtensionSource ... restSrc) {
        this.shortcut = shortcut;
        this.description = description;
        this.showInCatalogue = showInCatalogue;
        this.validSources = new ArrayList<ExtensionSource>();
        this.validSources.add(firstSrc);
        this.validSources.addAll(Arrays.asList(restSrc));
    }

    public char getShortcutKey() {
        return this.shortcut;
    }

    public String getDescription() {
        return this.description;
    }

    @OnThread(value=Tag.FXPlatform)
    public void activate() {
        if (this.action != null) {
            this.action.run();
        } else if (this.operation != null) {
            this.operation.activate(this.frame);
        } else {
            Debug.reportError("Action and Operation shouldn't be both null in ExtensionDescription:: " + this.description);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void activate(List<Frame> frames) {
        if (this.operation != null) {
            this.operation.activate(frames);
        } else {
            Debug.reportError("Operation shouldn't be null when calling activate(frames) in ExtensionDescription:: " + this.description);
        }
    }

    public boolean showInCatalogue() {
        return this.showInCatalogue;
    }

    public boolean validFor(ExtensionSource extensionSource) {
        return this.validSources.contains((Object)extensionSource);
    }

    public static enum ExtensionSource {
        BEFORE,
        AFTER,
        INSIDE_FIRST,
        INSIDE_LATER,
        MODIFIER,
        SELECTION;

    }
}

