/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.operations;

import bluej.Config;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.InteractionManager;
import bluej.stride.operations.FrameOperation;
import bluej.utility.javafx.AbstractOperation;
import java.util.Arrays;
import java.util.List;
import threadchecker.OnThread;
import threadchecker.Tag;

public class PullUpContentsOperation
extends FrameOperation {
    public PullUpContentsOperation(InteractionManager editor) {
        super(editor, "PULL_CONTENTS", AbstractOperation.Combine.ALL);
    }

    @Override
    public List<AbstractOperation.ItemLabel> getLabels() {
        return Arrays.asList(this.l(Config.getString("frame.operation.delete.outer"), AbstractOperation.MenuItemOrder.DELETE));
    }

    @Override
    protected AbstractOperation.Preview getPreview() {
        return new AbstractOperation.Preview(){

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void enablePreview() {
                PullUpContentsOperation.this.editor.getSelection().setPullUpPreview(true);
            }

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void disablePreview() {
                PullUpContentsOperation.this.editor.getSelection().setPullUpPreview(PullUpContentsOperation.super.onlyOnContextMenu());
            }
        };
    }

    @Override
    protected void execute(List<Frame> frames) {
        if (!frames.isEmpty()) {
            FrameCursor cursorBefore = frames.get(0).getCursorBefore();
            frames.forEach(frame -> {
                frame.pullUpContents();
                frame.getParentCanvas().removeBlock((Frame)frame);
            });
            cursorBefore.requestFocus();
        }
    }

    @Override
    public boolean onlyOnContextMenu() {
        return true;
    }
}

