import greenfoot.*;  // (World, Actor, GreenfootImage, Greenfoot und MouseInfo)
import java.util.ArrayList;

/**
 * Ergänzen Sie hier eine Beschreibung für die Klasse MyWorld.
 * 
 * @author (Ihr Name) 
 * @version (eine Versionsnummer oder ein Datum)
 */
public class Garten extends World
{
    Display display = new Display();
    /**
     * Konstruktor für Objekte der Klasse MyWorld
     * 
     */
    public Garten()
    {    
        // Erstellt eine neue Welt mit 600x400 Zellen und einer Zell-Größe von 1x1 Pixeln.
        super(12, 10, 64); 
        setPaintOrder(Display.class,Roboter.class, Kiste.class, Zettel.class, Marke.class, Zielfeld.class, Wiese.class);
        addObject(display, 6, 0);
        Greenfoot.setSpeed(50);
        prepare();
    }
    
    /**
     * Bereite die Welt für den Programmstart vor.
     * Das heißt: Erzeuge die Anfangs-Objekte und füge sie der Welt hinzu.
     */
    private void prepare()
    {
        //Wiese platzieren
        for(int i=0;i<12;i++){
            for(int j=0;j<10;j++){
                if(i==0 | j==0 | i==11 | j==9)
                {
                    Wiese wiesenstück = new Wiese();
                    addObject(wiesenstück,i,j);
                }
            }
        }
        //Roboter am Start platzieren
        Roboter r=new Roboter();
        addObject(r,6,8);
        //Kisten platzieren
        Kiste kiste = new Kiste();
        addObject(kiste,8,2);
        Kiste kiste2 = new Kiste();
        addObject(kiste2,2,3);
        Kiste kiste3 = new Kiste();
        addObject(kiste3,3,6);
        Kiste kiste4 = new Kiste();
        addObject(kiste4,9,5);
        //Zielfelder platzieren
        Zielfeld z1=new Zielfeld();
        addObject(z1,6,1);
        Zielfeld z2=new Zielfeld();
        addObject(z2,8,1);
        Zielfeld z3=new Zielfeld();
        addObject(z3,4,1);
        Zielfeld z4=new Zielfeld();
        addObject(z4,2,1);

        Zettel zettel = new Zettel();
        addObject(zettel,6,7);
        zettel.setText("Sammle die Kisten ein und setze sie auf den Zielfeldern ab.\n Du kannst immer nur eine Kiste gleichzeitig tragen.");
        Wiese wiese41 = new Wiese();
        addObject(wiese41,5,8);
        Wiese wiese42 = new Wiese();
        addObject(wiese42,5,7);
        Wiese wiese43 = new Wiese();
        addObject(wiese43,7,7);
        Wiese wiese44 = new Wiese();
        addObject(wiese44,7,8);
        Wiese wiese45 = new Wiese();
        addObject(wiese45,5,5);
        Wiese wiese46 = new Wiese();
        addObject(wiese46,5,4);
        Wiese wiese47 = new Wiese();
        addObject(wiese47,5,3);
        Wiese wiese48 = new Wiese();
        addObject(wiese48,6,3);
        Wiese wiese49 = new Wiese();
        addObject(wiese49,7,3);
        Wiese wiese50 = new Wiese();
        addObject(wiese50,7,4);
        Wiese wiese51 = new Wiese();
        addObject(wiese51,7,5);
        Wiese wiese52 = new Wiese();
        addObject(wiese52,1,5);
        Wiese wiese53 = new Wiese();
        addObject(wiese53,2,5);
        Wiese wiese54 = new Wiese();
        addObject(wiese54,2,2);
        Wiese wiese55 = new Wiese();
        addObject(wiese55,8,3);
        Wiese wiese56 = new Wiese();
        addObject(wiese56,9,3);
    }

    public void ausgabe(String text){
        int maxLänge=555;  //nach 555 Pixeln muss ein Umbruch erfolgen
        //Zerlege Text in einzelne Wörter, getrennt wird bei Leerzeichen
        //Füge Text zusammen, bis Länge von 560 erreicht wird oder alle Textteileaufgebraucht sind
        //Gib den aktuellen Teil aus
        String[] wörter=text.split(" ");
        //Prüfen, ob ein Wort selbst länger ist, als das Maximum --> ebenfalls splitten
        int anzZuLang=0;
        for(int i=0;i<wörter.length;i++){
            if(getLänge(wörter[i])>=maxLänge){
                anzZuLang++;
            }
        }
        //wenn es Wörter gibt, die zu lang sind, dann muss eine neues Wörter-Array erstellt werden
        if(anzZuLang>0){
            //System.out.println("Es gibt Wörter, die zu lang sind");
            ArrayList<String> neueWörter=new ArrayList<String>();   //leere Liste erstellen
            for(int i=0;i<wörter.length;i++){
                if(getLänge(wörter[i])<maxLänge){
                    neueWörter.add(wörter[i]);
                    //System.out.println("Das Wort "+wörter[i]+" war nicht zu lang.");
                }
                else{//Wörter splitten
                    //System.out.println("Das Wort "+wörter[i]+" muss geteilt werden.");
                    String wort=wörter[i];
                    String tempWort="";
                    int aktStelle=0;
                    while(aktStelle<wort.length()){
                        tempWort+=wort.charAt(aktStelle);
                        //System.out.println("  Aktuelles Teilwort: "+tempWort);
                        if(getLänge(tempWort)>=maxLänge){
                            neueWörter.add(tempWort);
                            //System.out.println("  Das Teilwort "+tempWort+" wurde der Liste hinzugefügt.");
                            tempWort="";
                        }
                        aktStelle++;
                    }
                    neueWörter.add(tempWort);
                    //System.out.println("  Das Teilwort "+tempWort+" wurde der Liste hinzugefügt.");
                }
            }
            wörter=new String[neueWörter.size()];
            for(int i=0;i<wörter.length;i++){
                wörter[i]=neueWörter.get(i);
            }
        }
        String subText="";
        int aktWort=0;
        while(aktWort<wörter.length){
            int aktLänge=getLänge(wörter[aktWort]);
            if(getLänge(subText)+aktLänge<=maxLänge){ //Wort kann angehängt werden
                subText+=wörter[aktWort]+" ";
                aktWort++;
                //System.out.println("Aktuelles teilwort: "+subText );
                //System.out.println("Aktuelle Wortlänge: "+aktLänge );
            }
            else if(aktLänge>=maxLänge){
                if(subText.length()>0)display.anzeigen(subText);//bisherigen Subtext ausgeben
                subText=wörter[aktWort];    //einzelnes langes Wort ausgeben
                display.anzeigen(subText);
                //System.out.println("Ausgabe ist nur ein Wort: "+subText );
                subText=""; //subText zurücksetzen
                aktWort++;  //Zähler erhöhen
            }
            else{
                display.anzeigen(subText);
                //System.out.println("Ausgabe müsste lauten: "+subText );
                subText="";
            }
        }
        if(getLänge(subText)>0){
            display.anzeigen(subText);
        }
        display.verstecken();
        
    }
    private int getLänge(String text){
        GreenfootImage image = new GreenfootImage(text, 25, Color.BLACK, null); // create text image
        return image.getWidth();
    }
}